#include <lib/std.mi>

Global Group frameGroup;
Global Slider slidercb;
Global Text fadertext;
Global Button CFIncrease, CFDecrease;
Global ToggleButton Crossfade;
Global Layer DisplayOverlay;

System.onScriptLoaded() {
	frameGroup = getScriptGroup();
	slidercb = frameGroup.findObject("sCrossfade");
	fadertext = frameGroup.findObject("CFDisplay");
	CFIncrease = frameGroup.findObject("CrossfadeIncrease");
	CFDecrease = frameGroup.findObject("CrossfadeDecrease");
	Crossfade = frameGroup.findObject("Crossfade");
	DisplayOverlay = frameGroup.findObject("crossfade.display.overlay");
	slidercb.onSetPosition(slidercb.getPosition());

	if (Crossfade.getActivated()) DisplayOverlay.hide();
}

slidercb.onSetPosition(int val) {
	String s = IntegerToString(val);
	fadertext.setText(s);
}

CFIncrease.onLeftClick() {
	slidercb.SetPosition(slidercb.getPosition()+1);
}

CFDecrease.onLeftClick() {
	slidercb.SetPosition(slidercb.getPosition()-1);
}

Crossfade.onToggle(boolean on) {
	if (on) DisplayOverlay.hide(); else DisplayOverlay.show();
}