#include <lib/std.mi>
#include "attribs.m"

Global Layout pl_normal;
Global Layout pl_shade;

System.onScriptLoaded() {
	initAttribs();
	menubar_pe_attrib.onDataChanged();
	pl_normal = getScriptGroup().getParentLayout();
}

menubar_pe_attrib.onDataChanged() {
	Group Player = getscriptgroup().findobject("player.content.pl.dummy.group");
	Group MenuBar = getscriptgroup().findobject("wasabi.menubar.pl");
	Layout main = getscriptgroup().getParentLayout();

	main.beforeRedock();
	if (getData() == "1") {
		Player.setXmlParam("y","16");
		MenuBar.show();
		main.snapAdjust(0,0,0,0);
	} else {
		Player.setXmlParam("y","0");
		MenuBar.hide();
		main.snapAdjust(0,0,0,16);
	}
	main.Redock();
}


System.onKeyDown(String k) {
  if (pl_shade == NULL)
    pl_shade = pl_normal.getContainer().getLayout("shade");

  if (StrLeft(k,4) == "ctrl" && StrSearch(k, "+w") != -1 && (pl_normal.isActive() || pl_shade.isActive())) {
    if (pl_normal.isVisible())
      pl_normal.getContainer().switchToLayout("shade");
    else
      pl_normal.getContainer().switchToLayout("normal");
    complete;
  }
  if (menubar_pe_attrib.getData() == "0") return;
  Layout l = getScriptGroup().getParentLayout();
  if (!l.isActive()) return;
  if (k == "alt+f") {
	getScriptGroup().findObject("File.menu").sendAction("open", "", 0, 0, 0, 0);
	complete;
  }
  if (k == "alt+p") {
	getScriptGroup().findObject("Playlist.menu").sendAction("open", "", 0, 0, 0, 0);
	complete;
  }
  if (k == "alt+s") {
	getScriptGroup().findObject("Sort.menu").sendAction("open", "", 0, 0, 0, 0);
	complete;
  }
  if (k == "alt+h") {
	getScriptGroup().findObject("Help.menu").sendAction("open", "", 0, 0, 0, 0);
	complete;
  }
}
