#include <lib/std.mi>
#include "attribs.m"

Global Group frameGroup;
Global Togglebutton ShuffleBtn,RepeatBtn,ShuffleBtn2,RepeatBtn2;
Global Timer SongTickerTimer;
Global Text SongTicker;
Global Slider Balance;

function setSongtickerScrolling();

System.onScriptLoaded() {
	initAttribs();
	frameGroup = getScriptGroup();
	SongTicker = frameGroup.findObject("songticker");
	SongTickerTimer = new Timer;
	SongTickerTimer.setDelay(1000);

	RepeatBtn = frameGroup.findObject("Repeat");
	ShuffleBtn = frameGroup.findObject("Shuffle");
	RepeatBtn2 = frameGroup.findObject("RepeatDisplay");
	ShuffleBtn2 = frameGroup.findObject("ShuffleDisplay");

	Balance = frameGroup.findObject("Balance");
	setSongtickerScrolling();
}


Balance.onSetPosition(int newpos) {
		string t="Balance:";
		if (newpos==127) t+="Center";
		if (newpos<127) t+="Left " + integerToString(100-(newpos/127)*100)+"%";
		if (newpos>127) t+="Right " + integerToString(((newpos-127)/127)*100)+"%";

		SongTickerTimer.start();
		SongTicker.setText(t);
}

SongTickerTimer.onTimer() {
	SongTicker.setText("");
	SongTickerTimer.stop();
}

System.onScriptUnloading() {
	delete SongTickerTimer;
}

RepeatBtn.onToggle(boolean on) {
		SongTickerTimer.start();
		int v = getCurCfgVal();
		if (v == 0) SongTicker.setText("Repeat: OFF");
                else if (v > 0) SongTicker.setText("Repeat: ALL");
                else if (v < 0) SongTicker.setText("Repeat: TRACK");
}

ShuffleBtn.onToggle(boolean on) {
		SongTickerTimer.start();
		if (on) SongTicker.setText("Playlist Shuffling: ON"); else SongTicker.setText("Playlist Shuffling: OFF");
}

RepeatBtn2.onToggle(boolean on) {
		SongTickerTimer.start();
		int v = getCurCfgVal();
		if (v == 0) SongTicker.setText("Repeat: OFF");
                else if (v > 0) SongTicker.setText("Repeat: ALL");
                else if (v < 0) SongTicker.setText("Repeat: TRACK");
}

ShuffleBtn2.onToggle(boolean on) {
		SongTickerTimer.start();
		if (on) SongTicker.setText("Playlist Shuffling: ON"); else SongTicker.setText("Playlist Shuffling: OFF");
}

songticker_scrolling_enabled_attrib.onDataChanged() {
	setSongtickerScrolling();
}

setSongtickerScrolling() {
	if (songticker_scrolling_enabled_attrib.getData()=="1") {
		SongTicker.setXMLParam("ticker","1");
	} else {
		SongTicker.setXMLParam("ticker","0");
	}
}
